@can('annual_report_create')
    <div style="margin-bottom: 10px;" class="row">
        <div class="col-lg-12">
            <a class="btn btn-success" href="{{ route('admin.annual-reports.create') }}">
                {{ trans('global.add') }} {{ trans('cruds.annualReport.title_singular') }}
            </a>
        </div>
    </div>
@endcan

<div class="card">
    <div class="card-header">
        {{ trans('cruds.annualReport.title_singular') }} {{ trans('global.list') }}
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class=" table table-bordered table-striped table-hover datatable datatable-teacherAnnualReports">
                <thead>
                    <tr>
                        <th width="10">

                        </th>
                        <th>
                            {{ trans('cruds.annualReport.fields.id') }}
                        </th>
                        <th>
                            {{ trans('cruds.annualReport.fields.name') }}
                        </th>
                        <th>
                            {{ trans('cruds.annualReport.fields.student') }}
                        </th>
                        <th>
                            {{ trans('cruds.student.fields.last_name') }}
                        </th>
                        <th>
                            {{ trans('cruds.student.fields.name_en') }}
                        </th>
                        <th>
                            {{ trans('cruds.student.fields.last_name_en') }}
                        </th>
                        <th>
                            {{ trans('cruds.annualReport.fields.teacher') }}
                        </th>
                        <th>
                            {{ trans('cruds.teacher.fields.last_name') }}
                        </th>
                        <th>
                            &nbsp;
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($annualReports as $key => $annualReport)
                        <tr data-entry-id="{{ $annualReport->id }}">
                            <td>

                            </td>
                            <td>
                                {{ $annualReport->id ?? '' }}
                            </td>
                            <td>
                                {{ $annualReport->name ?? '' }}
                            </td>
                            <td>
                                {{ $annualReport->student->name ?? '' }}
                            </td>
                            <td>
                                {{ $annualReport->student->last_name ?? '' }}
                            </td>
                            <td>
                                {{ $annualReport->student->name_en ?? '' }}
                            </td>
                            <td>
                                {{ $annualReport->student->last_name_en ?? '' }}
                            </td>
                            <td>
                                {{ $annualReport->teacher->last_name ?? '' }}
                            </td>
                            <td>
                                {{ $annualReport->teacher->last_name ?? '' }}
                            </td>
                            <td>
                                @can('annual_report_show')
                                    <a class="btn btn-xs btn-primary" href="{{ route('admin.annual-reports.show', $annualReport->id) }}">
                                        {{ trans('global.view') }}
                                    </a>
                                @endcan

                                @can('annual_report_edit')
                                    <a class="btn btn-xs btn-info" href="{{ route('admin.annual-reports.edit', $annualReport->id) }}">
                                        {{ trans('global.edit') }}
                                    </a>
                                @endcan

                                @can('annual_report_delete')
                                    <form action="{{ route('admin.annual-reports.destroy', $annualReport->id) }}" method="POST" onsubmit="return confirm('{{ trans('global.areYouSure') }}');" style="display: inline-block;">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        <input type="submit" class="btn btn-xs btn-danger" value="{{ trans('global.delete') }}">
                                    </form>
                                @endcan

                            </td>

                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@section('scripts')
@parent
<script>
    $(function () {
  let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
@can('annual_report_delete')
  let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
  let deleteButton = {
    text: deleteButtonTrans,
    url: "{{ route('admin.annual-reports.massDestroy') }}",
    className: 'btn-danger',
    action: function (e, dt, node, config) {
      var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
          return $(entry).data('entry-id')
      });

      if (ids.length === 0) {
        alert('{{ trans('global.datatables.zero_selected') }}')

        return
      }

      if (confirm('{{ trans('global.areYouSure') }}')) {
        $.ajax({
          headers: {'x-csrf-token': _token},
          method: 'POST',
          url: config.url,
          data: { ids: ids, _method: 'DELETE' }})
          .done(function () { location.reload() })
      }
    }
  }
  dtButtons.push(deleteButton)
@endcan

  $.extend(true, $.fn.dataTable.defaults, {
    orderCellsTop: true,
    order: [[ 1, 'desc' ]],
    pageLength: 100,
  });
  let table = $('.datatable-teacherAnnualReports:not(.ajaxTable)').DataTable({ buttons: dtButtons })
  $('a[data-toggle="tab"]').on('shown.bs.tab click', function(e){
      $($.fn.dataTable.tables(true)).DataTable()
          .columns.adjust();
  });
  
})

</script>
@endsection