@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.create') }} {{ trans('cruds.schTeacher.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.sch-teachers.store") }}" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label for="name_ua">{{ trans('cruds.schTeacher.fields.name_ua') }}</label>
                <input class="form-control {{ $errors->has('name_ua') ? 'is-invalid' : '' }}" type="text" name="name_ua" id="name_ua" value="{{ old('name_ua', '') }}">
                @if($errors->has('name_ua'))
                    <div class="invalid-feedback">
                        {{ $errors->first('name_ua') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.schTeacher.fields.name_ua_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="name_en">{{ trans('cruds.schTeacher.fields.name_en') }}</label>
                <input class="form-control {{ $errors->has('name_en') ? 'is-invalid' : '' }}" type="text" name="name_en" id="name_en" value="{{ old('name_en', '') }}">
                @if($errors->has('name_en'))
                    <div class="invalid-feedback">
                        {{ $errors->first('name_en') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.schTeacher.fields.name_en_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="schsubjects">{{ trans('cruds.schTeacher.fields.schsubject') }}</label>
                <div style="padding-bottom: 4px">
                    <span class="btn btn-info btn-xs select-all" style="border-radius: 0">{{ trans('global.select_all') }}</span>
                    <span class="btn btn-info btn-xs deselect-all" style="border-radius: 0">{{ trans('global.deselect_all') }}</span>
                </div>
                <select class="form-control select2 {{ $errors->has('schsubjects') ? 'is-invalid' : '' }}" name="schsubjects[]" id="schsubjects" multiple>
                    @foreach($schsubjects as $id => $schsubject)
                        <option value="{{ $id }}" {{ in_array($id, old('schsubjects', [])) ? 'selected' : '' }}>{{ $schsubject }}</option>
                    @endforeach
                </select>
                @if($errors->has('schsubjects'))
                    <div class="invalid-feedback">
                        {{ $errors->first('schsubjects') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.schTeacher.fields.schsubject_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="userid">{{ trans('cruds.schTeacher.fields.userid') }}</label>
                <input class="form-control {{ $errors->has('userid') ? 'is-invalid' : '' }}" type="text" name="userid" id="userid" value="{{ old('userid', '') }}">
                @if($errors->has('userid'))
                    <div class="invalid-feedback">
                        {{ $errors->first('userid') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.schTeacher.fields.userid_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection