<h5>Існуючі репорти:</h5>
<ul class="list-group">
    @forelse($reports as $report)
        <li class="list-group-item d-flex justify-content-between align-items-center">
            <div>
                {{ $report->created_at }} — {{ $report->schteacher->name_ua ?? '' }}: {{ $report->report }} |
                {{ $report->report_en }}
            </div>
            <div class="btn-group">
{{--                 <button type="button" class="btn btn-sm btn-info edit-report" data-report-id="{{ $report->id }}"
                    data-report-text="{{ $report->report }}" data-report-text-en="{{ $report->report_en }}">
                    <i class="fas fa-edit"></i> Редагувати
                </button> --}}
                <form action="{{ route('admin.sch-reports.destroy', $report->id) }}" method="POST"
                    style="display: inline-block;" onsubmit="return confirm('Ви впевнені?');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-sm btn-danger">
                        <i class="fas fa-trash"></i> Видалити
                    </button>
                </form>
            </div>
        </li>
    @empty
        <li class="list-group-item">Репортів ще немає.</li>
    @endforelse
</ul>

<hr>
<h5>Додати новий репорт:</h5>
<form method="POST" action="{{ route('admin.sch-reports.store') }}">
    @csrf
    <input type="hidden" name="class_id" value="{{ $classId }}">
    <input type="hidden" name="student_id" value="{{ $studentId }}">
    <div class="mb-2">
        <label>Вчитель</label>
        <input type="hidden" name="schteacher_id" value="{{ $teacherId }}">
        <input type="hidden" name="teacher_id" value="{{ $teacherUserId }}">
        <input type="text" class="form-control" value="{{ $schTeacherName ?? '' }}" readonly>
    </div>
    <div class="mb-2">
        <label>Предмет</label>
        <select name="subject_id" class="form-control">
            @foreach ($sch_subjects as $id => $name)
                <option value="{{ $id }}">{{ $name }}</option>
            @endforeach
        </select>
    </div>
    <div class="mb-2">
        <label>Текст репорту українською</label>
        <textarea name="report" class="form-control"></textarea>
    </div>
    <div class="mb-2">
        <label>Текст репорту англійською</label>
        <textarea name="report_en" class="form-control"></textarea>
    </div>
    <button type="submit" class="btn btn-primary">Додати репорт</button>
</form>

<script>
    $(document).ready(function() {
        $('.edit-report').click(function() {
            var reportId = $(this).data('report-id');
            var reportText = $(this).data('report-text');
            var reportTextEn = $(this).data('report-text-en');

            // Очищаем старый hidden input для метода, если он есть
            $('form input[name="_method"]').remove();

            // Заполняем форму данными для редактирования
            $('textarea[name="report"]').val(reportText);
            $('textarea[name="report_en"]').val(reportTextEn);

            // Меняем action формы и добавляем метод PUT
            var form = $('form');
            form.attr('action', '/admin/sch-reports/' + reportId);
            form.append('<input type="hidden" name="_method" value="PUT">');

            // Меняем текст кнопки
            $('button[type="submit"]').text('Оновити репорт');

            // Добавляем кнопку отмены
            if (!$('.cancel-edit').length) {
                $('button[type="submit"]').after(
                    '<button type="button" class="btn btn-secondary ml-2 cancel-edit">Скасувати</button>'
                );
            }
        });

        // Обработчик для кнопки отмены
        $(document).on('click', '.cancel-edit', function() {
            var form = $('form');
            // Возвращаем форму в исходное состояние
            form.attr('action', '{{ route('admin.sch-reports.store') }}');
            $('form input[name="_method"]').remove();
            $('textarea[name="report"]').val('');
            $('textarea[name="report_en"]').val('');
            $('button[type="submit"]').text('Додати репорт');
            $(this).remove();
        });
    });
</script>
