@extends('layouts.admin')
@section('content')
    <div class="card">
        <div class="card-header">
            {{ trans('global.show') }} {{ trans('cruds.schReport.title') }}
        </div>

        <div class="card-body">
            <div class="form-group">
                <div class="form-group">
                    <a class="btn btn-default" href="{{ route('admin.sch-reports.index') }}">
                        {{ trans('global.back_to_list') }}
                    </a>
                </div>
                <table class="table table-bordered table-striped">
                    <tbody>
                        <tr>
                            <th>
                                {{ trans('cruds.schReport.fields.id') }}
                            </th>
                            <td>
                                {{ $schReport->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.schReport.fields.schclass') }}
                            </th>
                            <td>
                                {{ $schReport->schclass->name ?? '' }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.schReport.fields.schstudent') }}
                            </th>
                            <td>
                                {{ $schReport->schstudent->name_ua ?? '' }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.schReport.fields.schteacher') }}
                            </th>
                            <td>
                                {{ $schReport->schteacher->name_ua ?? '' }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.schReport.fields.schsubject') }}
                            </th>
                            <td>
                                {{ $schReport->schsubject->name ?? '' }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.schReport.fields.report') }}
                            </th>
                            <td>
                                {{ $schReport->report }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.schReport.fields.report_en') }}
                            </th>
                            <td>
                                {{ $schReport->report_en }}
                            </td>
                        </tr>
                    </tbody>
                </table>
                <div class="form-group">
                    <a class="btn btn-default" href="{{ route('admin.sch-reports.index') }}">
                        {{ trans('global.back_to_list') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection
