@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.psihologAnketum.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.psiholog-anketa.update", [$psihologAnketum->id]) }}" enctype="multipart/form-data">
            @method('PUT')
            @csrf
            <div class="form-group">
                <label class="required" for="name_childe_id">{{ trans('cruds.psihologAnketum.fields.name_childe') }}</label>
                <select class="form-control select2 {{ $errors->has('name_childe') ? 'is-invalid' : '' }}" name="name_childe_id" id="name_childe_id" required>
                    @foreach($name_childes as $id => $entry)
                        <option value="{{ $id }}" {{ (old('name_childe_id') ? old('name_childe_id') : $psihologAnketum->name_childe->id ?? '') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('name_childe'))
                    <div class="invalid-feedback">
                        {{ $errors->first('name_childe') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.name_childe_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="date">{{ trans('cruds.psihologAnketum.fields.date') }}</label>
                <input class="form-control date {{ $errors->has('date') ? 'is-invalid' : '' }}" type="text" name="date" id="date" value="{{ old('date', $psihologAnketum->date) }}" required>
                @if($errors->has('date'))
                    <div class="invalid-feedback">
                        {{ $errors->first('date') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.date_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="name_psyholog_id">{{ trans('cruds.psihologAnketum.fields.name_psyholog') }}</label>
                <select class="form-control select2 {{ $errors->has('name_psyholog') ? 'is-invalid' : '' }}" name="name_psyholog_id" id="name_psyholog_id" required>
                    @foreach($name_psyhologs as $id => $entry)
                        <option value="{{ $id }}" {{ (old('name_psyholog_id') ? old('name_psyholog_id') : $psihologAnketum->name_psyholog->id ?? '') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('name_psyholog'))
                    <div class="invalid-feedback">
                        {{ $errors->first('name_psyholog') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.name_psyholog_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.psihologAnketum.fields.nebylici') }}</label>
                @foreach(App\Models\PsihologAnketum::NEBYLICI_RADIO as $key => $label)
                    <div class="form-check {{ $errors->has('nebylici') ? 'is-invalid' : '' }}">
                        <input class="form-check-input" type="radio" id="nebylici_{{ $key }}" name="nebylici" value="{{ $key }}" {{ old('nebylici', $psihologAnketum->nebylici) === (string) $key ? 'checked' : '' }}>
                        <label class="form-check-label" for="nebylici_{{ $key }}">{{ $label }}</label>
                    </div>
                @endforeach
                @if($errors->has('nebylici'))
                    <div class="invalid-feedback">
                        {{ $errors->first('nebylici') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.nebylici_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="visual_memory">{{ trans('cruds.psihologAnketum.fields.visual_memory') }}</label>
                <input class="form-control {{ $errors->has('visual_memory') ? 'is-invalid' : '' }}" type="number" name="visual_memory" id="visual_memory" value="{{ old('visual_memory', $psihologAnketum->visual_memory) }}" step="0.01" min="1" max="10">
                @if($errors->has('visual_memory'))
                    <div class="invalid-feedback">
                        {{ $errors->first('visual_memory') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.visual_memory_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.psihologAnketum.fields.reading') }}</label>
                @foreach(App\Models\PsihologAnketum::READING_RADIO as $key => $label)
                    <div class="form-check {{ $errors->has('reading') ? 'is-invalid' : '' }}">
                        <input class="form-check-input" type="radio" id="reading_{{ $key }}" name="reading" value="{{ $key }}" {{ old('reading', $psihologAnketum->reading) === (string) $key ? 'checked' : '' }}>
                        <label class="form-check-label" for="reading_{{ $key }}">{{ $label }}</label>
                    </div>
                @endforeach
                @if($errors->has('reading'))
                    <div class="invalid-feedback">
                        {{ $errors->first('reading') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.reading_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="auditory_memory">{{ trans('cruds.psihologAnketum.fields.auditory_memory') }}</label>
                <input class="form-control {{ $errors->has('auditory_memory') ? 'is-invalid' : '' }}" type="number" name="auditory_memory" id="auditory_memory" value="{{ old('auditory_memory', $psihologAnketum->auditory_memory) }}" step="0.01" min="1" max="6">
                @if($errors->has('auditory_memory'))
                    <div class="invalid-feedback">
                        {{ $errors->first('auditory_memory') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.auditory_memory_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.psihologAnketum.fields.fourth_is_redundant') }}</label>
                @foreach(App\Models\PsihologAnketum::FOURTH_IS_REDUNDANT_RADIO as $key => $label)
                    <div class="form-check {{ $errors->has('fourth_is_redundant') ? 'is-invalid' : '' }}">
                        <input class="form-check-input" type="radio" id="fourth_is_redundant_{{ $key }}" name="fourth_is_redundant" value="{{ $key }}" {{ old('fourth_is_redundant', $psihologAnketum->fourth_is_redundant) === (string) $key ? 'checked' : '' }}>
                        <label class="form-check-label" for="fourth_is_redundant_{{ $key }}">{{ $label }}</label>
                    </div>
                @endforeach
                @if($errors->has('fourth_is_redundant'))
                    <div class="invalid-feedback">
                        {{ $errors->first('fourth_is_redundant') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.fourth_is_redundant_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.psihologAnketum.fields.logical_lines') }}</label>
                @foreach(App\Models\PsihologAnketum::LOGICAL_LINES_RADIO as $key => $label)
                    <div class="form-check {{ $errors->has('logical_lines') ? 'is-invalid' : '' }}">
                        <input class="form-check-input" type="radio" id="logical_lines_{{ $key }}" name="logical_lines" value="{{ $key }}" {{ old('logical_lines', $psihologAnketum->logical_lines) === (string) $key ? 'checked' : '' }}>
                        <label class="form-check-label" for="logical_lines_{{ $key }}">{{ $label }}</label>
                    </div>
                @endforeach
                @if($errors->has('logical_lines'))
                    <div class="invalid-feedback">
                        {{ $errors->first('logical_lines') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.logical_lines_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('social_readiness') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="social_readiness" value="0">
                    <input class="form-check-input" type="checkbox" name="social_readiness" id="social_readiness" value="1" {{ $psihologAnketum->social_readiness || old('social_readiness', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="social_readiness">{{ trans('cruds.psihologAnketum.fields.social_readiness') }}</label>
                </div>
                @if($errors->has('social_readiness'))
                    <div class="invalid-feedback">
                        {{ $errors->first('social_readiness') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.social_readiness_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('social_readiness_2') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="social_readiness_2" value="0">
                    <input class="form-check-input" type="checkbox" name="social_readiness_2" id="social_readiness_2" value="1" {{ $psihologAnketum->social_readiness_2 || old('social_readiness_2', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="social_readiness_2">{{ trans('cruds.psihologAnketum.fields.social_readiness_2') }}</label>
                </div>
                @if($errors->has('social_readiness_2'))
                    <div class="invalid-feedback">
                        {{ $errors->first('social_readiness_2') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.social_readiness_2_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('social_readiness_3') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="social_readiness_3" value="0">
                    <input class="form-check-input" type="checkbox" name="social_readiness_3" id="social_readiness_3" value="1" {{ $psihologAnketum->social_readiness_3 || old('social_readiness_3', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="social_readiness_3">{{ trans('cruds.psihologAnketum.fields.social_readiness_3') }}</label>
                </div>
                @if($errors->has('social_readiness_3'))
                    <div class="invalid-feedback">
                        {{ $errors->first('social_readiness_3') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.social_readiness_3_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('social_readiness_4') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="social_readiness_4" value="0">
                    <input class="form-check-input" type="checkbox" name="social_readiness_4" id="social_readiness_4" value="1" {{ $psihologAnketum->social_readiness_4 || old('social_readiness_4', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="social_readiness_4">{{ trans('cruds.psihologAnketum.fields.social_readiness_4') }}</label>
                </div>
                @if($errors->has('social_readiness_4'))
                    <div class="invalid-feedback">
                        {{ $errors->first('social_readiness_4') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.social_readiness_4_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('social_readiness_5') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="social_readiness_5" value="0">
                    <input class="form-check-input" type="checkbox" name="social_readiness_5" id="social_readiness_5" value="1" {{ $psihologAnketum->social_readiness_5 || old('social_readiness_5', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="social_readiness_5">{{ trans('cruds.psihologAnketum.fields.social_readiness_5') }}</label>
                </div>
                @if($errors->has('social_readiness_5'))
                    <div class="invalid-feedback">
                        {{ $errors->first('social_readiness_5') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.social_readiness_5_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('social_readiness_6') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="social_readiness_6" value="0">
                    <input class="form-check-input" type="checkbox" name="social_readiness_6" id="social_readiness_6" value="1" {{ $psihologAnketum->social_readiness_6 || old('social_readiness_6', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="social_readiness_6">{{ trans('cruds.psihologAnketum.fields.social_readiness_6') }}</label>
                </div>
                @if($errors->has('social_readiness_6'))
                    <div class="invalid-feedback">
                        {{ $errors->first('social_readiness_6') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.social_readiness_6_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('social_readiness_7') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="social_readiness_7" value="0">
                    <input class="form-check-input" type="checkbox" name="social_readiness_7" id="social_readiness_7" value="1" {{ $psihologAnketum->social_readiness_7 || old('social_readiness_7', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="social_readiness_7">{{ trans('cruds.psihologAnketum.fields.social_readiness_7') }}</label>
                </div>
                @if($errors->has('social_readiness_7'))
                    <div class="invalid-feedback">
                        {{ $errors->first('social_readiness_7') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.social_readiness_7_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('self_regulation') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="self_regulation" value="0">
                    <input class="form-check-input" type="checkbox" name="self_regulation" id="self_regulation" value="1" {{ $psihologAnketum->self_regulation || old('self_regulation', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="self_regulation">{{ trans('cruds.psihologAnketum.fields.self_regulation') }}</label>
                </div>
                @if($errors->has('self_regulation'))
                    <div class="invalid-feedback">
                        {{ $errors->first('self_regulation') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.self_regulation_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('self_regulation_2') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="self_regulation_2" value="0">
                    <input class="form-check-input" type="checkbox" name="self_regulation_2" id="self_regulation_2" value="1" {{ $psihologAnketum->self_regulation_2 || old('self_regulation_2', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="self_regulation_2">{{ trans('cruds.psihologAnketum.fields.self_regulation_2') }}</label>
                </div>
                @if($errors->has('self_regulation_2'))
                    <div class="invalid-feedback">
                        {{ $errors->first('self_regulation_2') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.self_regulation_2_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('self_regulation_3') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="self_regulation_3" value="0">
                    <input class="form-check-input" type="checkbox" name="self_regulation_3" id="self_regulation_3" value="1" {{ $psihologAnketum->self_regulation_3 || old('self_regulation_3', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="self_regulation_3">{{ trans('cruds.psihologAnketum.fields.self_regulation_3') }}</label>
                </div>
                @if($errors->has('self_regulation_3'))
                    <div class="invalid-feedback">
                        {{ $errors->first('self_regulation_3') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.self_regulation_3_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('self_regulation_4') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="self_regulation_4" value="0">
                    <input class="form-check-input" type="checkbox" name="self_regulation_4" id="self_regulation_4" value="1" {{ $psihologAnketum->self_regulation_4 || old('self_regulation_4', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="self_regulation_4">{{ trans('cruds.psihologAnketum.fields.self_regulation_4') }}</label>
                </div>
                @if($errors->has('self_regulation_4'))
                    <div class="invalid-feedback">
                        {{ $errors->first('self_regulation_4') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.self_regulation_4_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('self_regulation_5') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="self_regulation_5" value="0">
                    <input class="form-check-input" type="checkbox" name="self_regulation_5" id="self_regulation_5" value="1" {{ $psihologAnketum->self_regulation_5 || old('self_regulation_5', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="self_regulation_5">{{ trans('cruds.psihologAnketum.fields.self_regulation_5') }}</label>
                </div>
                @if($errors->has('self_regulation_5'))
                    <div class="invalid-feedback">
                        {{ $errors->first('self_regulation_5') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.self_regulation_5_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('self_regulation_6') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="self_regulation_6" value="0">
                    <input class="form-check-input" type="checkbox" name="self_regulation_6" id="self_regulation_6" value="1" {{ $psihologAnketum->self_regulation_6 || old('self_regulation_6', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="self_regulation_6">{{ trans('cruds.psihologAnketum.fields.self_regulation_6') }}</label>
                </div>
                @if($errors->has('self_regulation_6'))
                    <div class="invalid-feedback">
                        {{ $errors->first('self_regulation_6') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.self_regulation_6_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('self_regulation_7') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="self_regulation_7" value="0">
                    <input class="form-check-input" type="checkbox" name="self_regulation_7" id="self_regulation_7" value="1" {{ $psihologAnketum->self_regulation_7 || old('self_regulation_7', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="self_regulation_7">{{ trans('cruds.psihologAnketum.fields.self_regulation_7') }}</label>
                </div>
                @if($errors->has('self_regulation_7'))
                    <div class="invalid-feedback">
                        {{ $errors->first('self_regulation_7') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.self_regulation_7_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('self_regulation_8') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="self_regulation_8" value="0">
                    <input class="form-check-input" type="checkbox" name="self_regulation_8" id="self_regulation_8" value="1" {{ $psihologAnketum->self_regulation_8 || old('self_regulation_8', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="self_regulation_8">{{ trans('cruds.psihologAnketum.fields.self_regulation_8') }}</label>
                </div>
                @if($errors->has('self_regulation_8'))
                    <div class="invalid-feedback">
                        {{ $errors->first('self_regulation_8') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.self_regulation_8_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('self_regulation_9') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="self_regulation_9" value="0">
                    <input class="form-check-input" type="checkbox" name="self_regulation_9" id="self_regulation_9" value="1" {{ $psihologAnketum->self_regulation_9 || old('self_regulation_9', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="self_regulation_9">{{ trans('cruds.psihologAnketum.fields.self_regulation_9') }}</label>
                </div>
                @if($errors->has('self_regulation_9'))
                    <div class="invalid-feedback">
                        {{ $errors->first('self_regulation_9') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.self_regulation_9_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.psihologAnketum.fields.motivation_to_study') }}</label>
                @foreach(App\Models\PsihologAnketum::MOTIVATION_TO_STUDY_RADIO as $key => $label)
                    <div class="form-check {{ $errors->has('motivation_to_study') ? 'is-invalid' : '' }}">
                        <input class="form-check-input" type="radio" id="motivation_to_study_{{ $key }}" name="motivation_to_study" value="{{ $key }}" {{ old('motivation_to_study', $psihologAnketum->motivation_to_study) === (string) $key ? 'checked' : '' }}>
                        <label class="form-check-label" for="motivation_to_study_{{ $key }}">{{ $label }}</label>
                    </div>
                @endforeach
                @if($errors->has('motivation_to_study'))
                    <div class="invalid-feedback">
                        {{ $errors->first('motivation_to_study') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.motivation_to_study_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('speech_physiology') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="speech_physiology" value="0">
                    <input class="form-check-input" type="checkbox" name="speech_physiology" id="speech_physiology" value="1" {{ $psihologAnketum->speech_physiology || old('speech_physiology', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="speech_physiology">{{ trans('cruds.psihologAnketum.fields.speech_physiology') }}</label>
                </div>
                @if($errors->has('speech_physiology'))
                    <div class="invalid-feedback">
                        {{ $errors->first('speech_physiology') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.speech_physiology_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('speech_physiology_2') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="speech_physiology_2" value="0">
                    <input class="form-check-input" type="checkbox" name="speech_physiology_2" id="speech_physiology_2" value="1" {{ $psihologAnketum->speech_physiology_2 || old('speech_physiology_2', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="speech_physiology_2">{{ trans('cruds.psihologAnketum.fields.speech_physiology_2') }}</label>
                </div>
                @if($errors->has('speech_physiology_2'))
                    <div class="invalid-feedback">
                        {{ $errors->first('speech_physiology_2') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.speech_physiology_2_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('speech_physiology_3') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="speech_physiology_3" value="0">
                    <input class="form-check-input" type="checkbox" name="speech_physiology_3" id="speech_physiology_3" value="1" {{ $psihologAnketum->speech_physiology_3 || old('speech_physiology_3', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="speech_physiology_3">{{ trans('cruds.psihologAnketum.fields.speech_physiology_3') }}</label>
                </div>
                @if($errors->has('speech_physiology_3'))
                    <div class="invalid-feedback">
                        {{ $errors->first('speech_physiology_3') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.speech_physiology_3_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('speech_physiology_4') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="speech_physiology_4" value="0">
                    <input class="form-check-input" type="checkbox" name="speech_physiology_4" id="speech_physiology_4" value="1" {{ $psihologAnketum->speech_physiology_4 || old('speech_physiology_4', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="speech_physiology_4">{{ trans('cruds.psihologAnketum.fields.speech_physiology_4') }}</label>
                </div>
                @if($errors->has('speech_physiology_4'))
                    <div class="invalid-feedback">
                        {{ $errors->first('speech_physiology_4') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.speech_physiology_4_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('speech_physiology_5') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="speech_physiology_5" value="0">
                    <input class="form-check-input" type="checkbox" name="speech_physiology_5" id="speech_physiology_5" value="1" {{ $psihologAnketum->speech_physiology_5 || old('speech_physiology_5', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="speech_physiology_5">{{ trans('cruds.psihologAnketum.fields.speech_physiology_5') }}</label>
                </div>
                @if($errors->has('speech_physiology_5'))
                    <div class="invalid-feedback">
                        {{ $errors->first('speech_physiology_5') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.speech_physiology_5_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('speech_physiology_6') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="speech_physiology_6" value="0">
                    <input class="form-check-input" type="checkbox" name="speech_physiology_6" id="speech_physiology_6" value="1" {{ $psihologAnketum->speech_physiology_6 || old('speech_physiology_6', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="speech_physiology_6">{{ trans('cruds.psihologAnketum.fields.speech_physiology_6') }}</label>
                </div>
                @if($errors->has('speech_physiology_6'))
                    <div class="invalid-feedback">
                        {{ $errors->first('speech_physiology_6') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.speech_physiology_6_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('speech_physiology_7') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="speech_physiology_7" value="0">
                    <input class="form-check-input" type="checkbox" name="speech_physiology_7" id="speech_physiology_7" value="1" {{ $psihologAnketum->speech_physiology_7 || old('speech_physiology_7', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="speech_physiology_7">{{ trans('cruds.psihologAnketum.fields.speech_physiology_7') }}</label>
                </div>
                @if($errors->has('speech_physiology_7'))
                    <div class="invalid-feedback">
                        {{ $errors->first('speech_physiology_7') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.speech_physiology_7_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('speech_physiology_8') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="speech_physiology_8" value="0">
                    <input class="form-check-input" type="checkbox" name="speech_physiology_8" id="speech_physiology_8" value="1" {{ $psihologAnketum->speech_physiology_8 || old('speech_physiology_8', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="speech_physiology_8">{{ trans('cruds.psihologAnketum.fields.speech_physiology_8') }}</label>
                </div>
                @if($errors->has('speech_physiology_8'))
                    <div class="invalid-feedback">
                        {{ $errors->first('speech_physiology_8') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.speech_physiology_8_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('physiology_0') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="physiology_0" value="0">
                    <input class="form-check-input" type="checkbox" name="physiology_0" id="physiology_0" value="1" {{ $psihologAnketum->physiology_0 || old('physiology_0', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="physiology_0">{{ trans('cruds.psihologAnketum.fields.physiology_0') }}</label>
                </div>
                @if($errors->has('physiology_0'))
                    <div class="invalid-feedback">
                        {{ $errors->first('physiology_0') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.physiology_0_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('physiology') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="physiology" value="0">
                    <input class="form-check-input" type="checkbox" name="physiology" id="physiology" value="1" {{ $psihologAnketum->physiology || old('physiology', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="physiology">{{ trans('cruds.psihologAnketum.fields.physiology') }}</label>
                </div>
                @if($errors->has('physiology'))
                    <div class="invalid-feedback">
                        {{ $errors->first('physiology') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.physiology_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('physiology_2') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="physiology_2" value="0">
                    <input class="form-check-input" type="checkbox" name="physiology_2" id="physiology_2" value="1" {{ $psihologAnketum->physiology_2 || old('physiology_2', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="physiology_2">{{ trans('cruds.psihologAnketum.fields.physiology_2') }}</label>
                </div>
                @if($errors->has('physiology_2'))
                    <div class="invalid-feedback">
                        {{ $errors->first('physiology_2') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.physiology_2_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('physiology_3') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="physiology_3" value="0">
                    <input class="form-check-input" type="checkbox" name="physiology_3" id="physiology_3" value="1" {{ $psihologAnketum->physiology_3 || old('physiology_3', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="physiology_3">{{ trans('cruds.psihologAnketum.fields.physiology_3') }}</label>
                </div>
                @if($errors->has('physiology_3'))
                    <div class="invalid-feedback">
                        {{ $errors->first('physiology_3') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.physiology_3_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('physiology_4') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="physiology_4" value="0">
                    <input class="form-check-input" type="checkbox" name="physiology_4" id="physiology_4" value="1" {{ $psihologAnketum->physiology_4 || old('physiology_4', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="physiology_4">{{ trans('cruds.psihologAnketum.fields.physiology_4') }}</label>
                </div>
                @if($errors->has('physiology_4'))
                    <div class="invalid-feedback">
                        {{ $errors->first('physiology_4') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.physiology_4_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.psihologAnketum.fields.reading_tempo') }}</label>
                @foreach(App\Models\PsihologAnketum::READING_TEMPO_RADIO as $key => $label)
                    <div class="form-check {{ $errors->has('reading_tempo') ? 'is-invalid' : '' }}">
                        <input class="form-check-input" type="radio" id="reading_tempo_{{ $key }}" name="reading_tempo" value="{{ $key }}" {{ old('reading_tempo', $psihologAnketum->reading_tempo) === (string) $key ? 'checked' : '' }}>
                        <label class="form-check-label" for="reading_tempo_{{ $key }}">{{ $label }}</label>
                    </div>
                @endforeach
                @if($errors->has('reading_tempo'))
                    <div class="invalid-feedback">
                        {{ $errors->first('reading_tempo') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.reading_tempo_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.psihologAnketum.fields.way_of_reading') }}</label>
                @foreach(App\Models\PsihologAnketum::WAY_OF_READING_RADIO as $key => $label)
                    <div class="form-check {{ $errors->has('way_of_reading') ? 'is-invalid' : '' }}">
                        <input class="form-check-input" type="radio" id="way_of_reading_{{ $key }}" name="way_of_reading" value="{{ $key }}" {{ old('way_of_reading', $psihologAnketum->way_of_reading) === (string) $key ? 'checked' : '' }}>
                        <label class="form-check-label" for="way_of_reading_{{ $key }}">{{ $label }}</label>
                    </div>
                @endforeach
                @if($errors->has('way_of_reading'))
                    <div class="invalid-feedback">
                        {{ $errors->first('way_of_reading') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.way_of_reading_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('fish') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="fish" value="0">
                    <input class="form-check-input" type="checkbox" name="fish" id="fish" value="1" {{ $psihologAnketum->fish || old('fish', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="fish">{{ trans('cruds.psihologAnketum.fields.fish') }}</label>
                </div>
                @if($errors->has('fish'))
                    <div class="invalid-feedback">
                        {{ $errors->first('fish') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.fish_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('fish_2') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="fish_2" value="0">
                    <input class="form-check-input" type="checkbox" name="fish_2" id="fish_2" value="1" {{ $psihologAnketum->fish_2 || old('fish_2', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="fish_2">{{ trans('cruds.psihologAnketum.fields.fish_2') }}</label>
                </div>
                @if($errors->has('fish_2'))
                    <div class="invalid-feedback">
                        {{ $errors->first('fish_2') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.fish_2_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('fish_3') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="fish_3" value="0">
                    <input class="form-check-input" type="checkbox" name="fish_3" id="fish_3" value="1" {{ $psihologAnketum->fish_3 || old('fish_3', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="fish_3">{{ trans('cruds.psihologAnketum.fields.fish_3') }}</label>
                </div>
                @if($errors->has('fish_3'))
                    <div class="invalid-feedback">
                        {{ $errors->first('fish_3') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.fish_3_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('fish_4') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="fish_4" value="0">
                    <input class="form-check-input" type="checkbox" name="fish_4" id="fish_4" value="1" {{ $psihologAnketum->fish_4 || old('fish_4', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="fish_4">{{ trans('cruds.psihologAnketum.fields.fish_4') }}</label>
                </div>
                @if($errors->has('fish_4'))
                    <div class="invalid-feedback">
                        {{ $errors->first('fish_4') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.fish_4_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('copying_figures') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="copying_figures" value="0">
                    <input class="form-check-input" type="checkbox" name="copying_figures" id="copying_figures" value="1" {{ $psihologAnketum->copying_figures || old('copying_figures', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="copying_figures">{{ trans('cruds.psihologAnketum.fields.copying_figures') }}</label>
                </div>
                @if($errors->has('copying_figures'))
                    <div class="invalid-feedback">
                        {{ $errors->first('copying_figures') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.copying_figures_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('copying_figures_2') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="copying_figures_2" value="0">
                    <input class="form-check-input" type="checkbox" name="copying_figures_2" id="copying_figures_2" value="1" {{ $psihologAnketum->copying_figures_2 || old('copying_figures_2', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="copying_figures_2">{{ trans('cruds.psihologAnketum.fields.copying_figures_2') }}</label>
                </div>
                @if($errors->has('copying_figures_2'))
                    <div class="invalid-feedback">
                        {{ $errors->first('copying_figures_2') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.copying_figures_2_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('copying_figures_3') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="copying_figures_3" value="0">
                    <input class="form-check-input" type="checkbox" name="copying_figures_3" id="copying_figures_3" value="1" {{ $psihologAnketum->copying_figures_3 || old('copying_figures_3', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="copying_figures_3">{{ trans('cruds.psihologAnketum.fields.copying_figures_3') }}</label>
                </div>
                @if($errors->has('copying_figures_3'))
                    <div class="invalid-feedback">
                        {{ $errors->first('copying_figures_3') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.copying_figures_3_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="interview">{{ trans('cruds.psihologAnketum.fields.interview') }}</label>
                <input class="form-control {{ $errors->has('interview') ? 'is-invalid' : '' }}" type="number" name="interview" id="interview" value="{{ old('interview', $psihologAnketum->interview) }}" step="1">
                @if($errors->has('interview'))
                    <div class="invalid-feedback">
                        {{ $errors->first('interview') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.interview_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.psihologAnketum.fields.conclusion') }}</label>
                <select class="form-control {{ $errors->has('conclusion') ? 'is-invalid' : '' }}" name="conclusion" id="conclusion">
                    <option value disabled {{ old('conclusion', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                    @foreach(App\Models\PsihologAnketum::CONCLUSION_SELECT as $key => $label)
                        <option value="{{ $key }}" {{ old('conclusion', $psihologAnketum->conclusion) === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @if($errors->has('conclusion'))
                    <div class="invalid-feedback">
                        {{ $errors->first('conclusion') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.conclusion_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="behavior">{{ trans('cruds.psihologAnketum.fields.behavior') }}</label>
                <textarea class="form-control {{ $errors->has('behavior') ? 'is-invalid' : '' }}" name="behavior" id="behavior">{{ old('behavior', $psihologAnketum->behavior) }}</textarea>
                @if($errors->has('behavior'))
                    <div class="invalid-feedback">
                        {{ $errors->first('behavior') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.psihologAnketum.fields.behavior_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection