<?php

namespace App\Http\Requests;

use App\Models\PsihologAnketum;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdatePsihologAnketumRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('psiholog_anketum_edit');
    }

    public function rules()
    {
        return [
            'name_childe_id' => [
                'required',
                'integer',
            ],
            'date' => [
                'required',
                'date_format:' . config('panel.date_format'),
            ],
            'name_psyholog_id' => [
                'required',
                'integer',
            ],
            'visual_memory' => [
                'numeric',
                'min:1',
                'max:10',
            ],
            'auditory_memory' => [
                'numeric',
                'min:1',
                'max:6',
            ],
            'interview' => [
                'nullable',
                'integer',
                'min:-2147483648',
                'max:2147483647',
            ],
        ];
    }
}
