<?php

namespace App\Http\Requests;

use App\Models\SchTeacher;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreSchTeacherRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('sch_teacher_create');
    }

    public function rules()
    {
        return [
            'name_ua' => [
                'string',
                'nullable',
            ],
            'name_en' => [
                'string',
                'nullable',
            ],
            'schsubjects.*' => [
                'integer',
            ],
            'schsubjects' => [
                'array',
            ],
            'userid' => [
                'string',
                'nullable',
            ],
        ];
    }
}
