<?php

namespace App\Http\Requests;

use App\Models\PsihologAnketum;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Symfony\Component\HttpFoundation\Response;

class MassDestroyPsihologAnketumRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(Gate::denies('psiholog_anketum_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:psiholog_anketa,id',
        ];
    }
}
