<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\CsvImportTrait;
use App\Http\Requests\MassDestroySchClassRequest;
use App\Http\Requests\StoreSchClassRequest;
use App\Http\Requests\UpdateSchClassRequest;
use App\Models\SchClass;
use App\Models\Schstudent;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SchClassController extends Controller
{
    use CsvImportTrait;

    public function index()
    {
        abort_if(Gate::denies('sch_class_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $schClasses = SchClass::with(['schstudents'])->get();

        $schstudents = Schstudent::get();

        return view('admin.schClasses.index', compact('schClasses', 'schstudents'));
    }

    public function create()
    {
        abort_if(Gate::denies('sch_class_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        /*         $schstudents = Schstudent::pluck('name_ua', 'id'); */
        // Вибираємо лише учнів без класу
        $schstudents = Schstudent::whereDoesntHave('schstudentSchClasses')->pluck('name_ua', 'id');

        return view('admin.schClasses.create', compact('schstudents'));
    }

    public function store(StoreSchClassRequest $request)
    {
        $schClass = SchClass::create($request->all());
        $schClass->schstudents()->sync($request->input('schstudents', []));

        // Оновлюємо поле schclass_id для кожного учня
        foreach ($request->input('schstudents', []) as $studentId) {
            $student = Schstudent::find($studentId);
            if ($student) {
                $student->update(['schclass_id' => $schClass->id]);
            }
        }

        return redirect()->route('admin.sch-classes.index')->with('success', 'Клас успішно створено!');
    }

    public function edit(SchClass $schClass)
    {
        abort_if(Gate::denies('sch_class_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        /* $schstudents = Schstudent::pluck('name_ua', 'id'); */

        // Вибираємо учнів без класу або тих, хто вже у цьому класі
        $schstudents = Schstudent::whereDoesntHave('schstudentSchClasses')
            ->orWhereHas('schstudentSchClasses', function ($q) use ($schClass) {
                $q->where('sch_class_id', $schClass->id);
            })
            ->pluck('name_ua', 'id');


        $schClass->load('schstudents');

        return view('admin.schClasses.edit', compact('schClass', 'schstudents'));
    }

    public function update(UpdateSchClassRequest $request, SchClass $schClass)
    {
        $schClass->update($request->all());
        $schClass->schstudents()->sync($request->input('schstudents', []));

        // Оновлюємо поле schclass_id для кожного учня
        foreach ($request->input('schstudents', []) as $studentId) {
            $student = Schstudent::find($studentId);
            if ($student) {
                $student->update(['schclass_id' => $schClass->id]);
            }
        }

        return redirect()->route('admin.sch-classes.index')->with('success', 'Клас успішно оновлено!');
    }

    public function show(SchClass $schClass)
    {
        abort_if(Gate::denies('sch_class_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $schClass->load('schstudents', 'schClassSchSubjects');

        return view('admin.schClasses.show', compact('schClass'));
    }

    public function destroy(SchClass $schClass)
    {
        abort_if(Gate::denies('sch_class_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $schClass->delete();

        return back();
    }

    public function massDestroy(MassDestroySchClassRequest $request)
    {
        $schClasses = SchClass::find(request('ids'));

        foreach ($schClasses as $schClass) {
            $schClass->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
