@can('sch_report_create')
    <div style="margin-bottom: 10px;" class="row">
        <div class="col-lg-12">
            <a class="btn btn-success" href="{{ route('admin.sch-reports.create') }}">
                {{ trans('global.add') }} {{ trans('cruds.schReport.title_singular') }}
            </a>
        </div>
    </div>
@endcan

<div class="card">
    <div class="card-header">
        {{ trans('cruds.schReport.title_singular') }} {{ trans('global.list') }}
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class=" table table-bordered table-striped table-hover datatable datatable-schstudentSchReports">
                <thead>
                    <tr>
                        <th width="10">

                        </th>
                        <th>
                            {{ trans('cruds.schReport.fields.id') }}
                        </th>
                        <th>
                            {{ trans('cruds.schReport.fields.schstudent') }}
                        </th>
                        <th>
                            {{ trans('cruds.schstudent.fields.name_en') }}
                        </th>
                        <th>
                            {{ trans('cruds.schstudent.fields.userid') }}
                        </th>
                        <th>
                            {{ trans('cruds.schReport.fields.schteacher') }}
                        </th>
                        <th>
                            {{ trans('cruds.schReport.fields.schsubject') }}
                        </th>
                        <th>
                            {{ trans('cruds.schReport.fields.report') }}
                        </th>
                        <th>
                            {{ trans('cruds.schReport.fields.report_en') }}
                        </th>
                        <th>
                            &nbsp;
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($schReports as $key => $schReport)
                        <tr data-entry-id="{{ $schReport->id }}">
                            <td>

                            </td>
                            <td>
                                {{ $schReport->id ?? '' }}
                            </td>
                            <td>
                                {{ $schReport->schstudent->name_ua ?? '' }}
                            </td>
                            <td>
                                {{ $schReport->schstudent->name_en ?? '' }}
                            </td>
                            <td>
                                {{ $schReport->schstudent->userid ?? '' }}
                            </td>
                            <td>
                                {{ $schReport->schteacher->name_ua ?? '' }}
                            </td>
                            <td>
                                {{ $schReport->schsubject->name ?? '' }}
                            </td>
                            <td>
                                {{ $schReport->report ?? '' }}
                            </td>
                            <td>
                                {{ $schReport->report_en ?? '' }}
                            </td>
                            <td>
                                @can('sch_report_show')
                                    <a class="btn btn-xs btn-primary" href="{{ route('admin.sch-reports.show', $schReport->id) }}">
                                        {{ trans('global.view') }}
                                    </a>
                                @endcan

                                @can('sch_report_edit')
                                    <a class="btn btn-xs btn-info" href="{{ route('admin.sch-reports.edit', $schReport->id) }}">
                                        {{ trans('global.edit') }}
                                    </a>
                                @endcan

                                @can('sch_report_delete')
                                    <form action="{{ route('admin.sch-reports.destroy', $schReport->id) }}" method="POST" onsubmit="return confirm('{{ trans('global.areYouSure') }}');" style="display: inline-block;">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        <input type="submit" class="btn btn-xs btn-danger" value="{{ trans('global.delete') }}">
                                    </form>
                                @endcan

                            </td>

                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@section('scripts')
@parent
<script>
    $(function () {
  let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
@can('sch_report_delete')
  let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
  let deleteButton = {
    text: deleteButtonTrans,
    url: "{{ route('admin.sch-reports.massDestroy') }}",
    className: 'btn-danger',
    action: function (e, dt, node, config) {
      var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
          return $(entry).data('entry-id')
      });

      if (ids.length === 0) {
        alert('{{ trans('global.datatables.zero_selected') }}')

        return
      }

      if (confirm('{{ trans('global.areYouSure') }}')) {
        $.ajax({
          headers: {'x-csrf-token': _token},
          method: 'POST',
          url: config.url,
          data: { ids: ids, _method: 'DELETE' }})
          .done(function () { location.reload() })
      }
    }
  }
  dtButtons.push(deleteButton)
@endcan

  $.extend(true, $.fn.dataTable.defaults, {
    orderCellsTop: true,
    order: [[ 1, 'desc' ]],
    pageLength: 100,
  });
  let table = $('.datatable-schstudentSchReports:not(.ajaxTable)').DataTable({ buttons: dtButtons })
  $('a[data-toggle="tab"]').on('shown.bs.tab click', function(e){
      $($.fn.dataTable.tables(true)).DataTable()
          .columns.adjust();
  });
  
})

</script>
@endsection