@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.schSubject.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.sch-subjects.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.schSubject.fields.id') }}
                        </th>
                        <td>
                            {{ $schSubject->id }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.schSubject.fields.name') }}
                        </th>
                        <td>
                            {{ $schSubject->name }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.schSubject.fields.sch_class') }}
                        </th>
                        <td>
                            {{ $schSubject->sch_class->name ?? '' }}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.sch-subjects.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        {{ trans('global.relatedData') }}
    </div>
    <ul class="nav nav-tabs" role="tablist" id="relationship-tabs">
        <li class="nav-item">
            <a class="nav-link" href="#schsubject_sch_reports" role="tab" data-toggle="tab">
                {{ trans('cruds.schReport.title') }}
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="#schsubject_sch_teachers" role="tab" data-toggle="tab">
                {{ trans('cruds.schTeacher.title') }}
            </a>
        </li>
    </ul>
    <div class="tab-content">
        <div class="tab-pane" role="tabpanel" id="schsubject_sch_reports">
            @includeIf('admin.schSubjects.relationships.schsubjectSchReports', ['schReports' => $schSubject->schsubjectSchReports])
        </div>
        <div class="tab-pane" role="tabpanel" id="schsubject_sch_teachers">
            @includeIf('admin.schSubjects.relationships.schsubjectSchTeachers', ['schTeachers' => $schSubject->schsubjectSchTeachers])
        </div>
    </div>
</div>

@endsection