@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.schClass.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.sch-classes.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.schClass.fields.id') }}
                        </th>
                        <td>
                            {{ $schClass->id }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.schClass.fields.name') }}
                        </th>
                        <td>
                            {{ $schClass->name }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.schClass.fields.schstudent') }}
                        </th>
                        <td>
                            @foreach($schClass->schstudents as $key => $schstudent)
                                <span class="label label-info">{{ $schstudent->name_ua }}</span>
                            @endforeach
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.sch-classes.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        {{ trans('global.relatedData') }}
    </div>
    <ul class="nav nav-tabs" role="tablist" id="relationship-tabs">
        <li class="nav-item">
            <a class="nav-link" href="#sch_class_sch_subjects" role="tab" data-toggle="tab">
                {{ trans('cruds.schSubject.title') }}
            </a>
        </li>
    </ul>
    <div class="tab-content">
        <div class="tab-pane" role="tabpanel" id="sch_class_sch_subjects">
            @includeIf('admin.schClasses.relationships.schClassSchSubjects', ['schSubjects' => $schClass->schClassSchSubjects])
        </div>
    </div>
</div>

@endsection