@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.create') }} {{ trans('cruds.schClass.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.sch-classes.store") }}" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label for="name">{{ trans('cruds.schClass.fields.name') }}</label>
                <input class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" type="text" name="name" id="name" value="{{ old('name', '') }}">
                @if($errors->has('name'))
                    <div class="invalid-feedback">
                        {{ $errors->first('name') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.schClass.fields.name_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="schstudents">{{ trans('cruds.schClass.fields.schstudent') }}</label>
                <div style="padding-bottom: 4px">
                    <span class="btn btn-info btn-xs select-all" style="border-radius: 0">{{ trans('global.select_all') }}</span>
                    <span class="btn btn-info btn-xs deselect-all" style="border-radius: 0">{{ trans('global.deselect_all') }}</span>
                </div>
                <select class="form-control select2 {{ $errors->has('schstudents') ? 'is-invalid' : '' }}" name="schstudents[]" id="schstudents" multiple>
                    @foreach($schstudents as $id => $schstudent)
                        <option value="{{ $id }}" {{ in_array($id, old('schstudents', [])) ? 'selected' : '' }}>{{ $schstudent }}</option>
                    @endforeach
                </select>
                @if($errors->has('schstudents'))
                    <div class="invalid-feedback">
                        {{ $errors->first('schstudents') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.schClass.fields.schstudent_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection