@extends('layouts.admin')
@section('content')
@can('psiholog_anketum_create')
    <div style="margin-bottom: 10px;" class="row">
        <div class="col-lg-12">
            <a class="btn btn-success" href="{{ route('admin.psiholog-anketa.create') }}">
                {{ trans('global.add') }} {{ trans('cruds.psihologAnketum.title_singular') }}
            </a>
            <button class="btn btn-warning" data-toggle="modal" data-target="#csvImportModal">
                {{ trans('global.app_csvImport') }}
            </button>
            @include('csvImport.modal', ['model' => 'PsihologAnketum', 'route' => 'admin.psiholog-anketa.parseCsvImport'])
        </div>
    </div>
@endcan
<div class="card">
    <div class="card-header">
        {{ trans('cruds.psihologAnketum.title_singular') }} {{ trans('global.list') }}
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class=" table table-bordered table-striped table-hover datatable datatable-PsihologAnketum">
                <thead>
                    <tr>
                        <th width="10">

                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.id') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.name_childe') }}
                        </th>
                        <th>
                            {{ trans('cruds.crmCustomer.fields.date') }}
                        </th>
                        <th>
                            {{ trans('cruds.crmCustomer.fields.name_parent') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.date') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.name_psyholog') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.nebylici') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.visual_memory') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.reading') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.auditory_memory') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.fourth_is_redundant') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.logical_lines') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness_2') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness_3') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness_4') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness_5') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness_6') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness_7') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_2') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_3') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_4') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_5') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_6') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_7') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_8') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_9') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.motivation_to_study') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_2') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_3') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_4') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_5') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_6') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_7') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_8') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.physiology_0') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.physiology') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.physiology_2') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.physiology_3') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.physiology_4') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.reading_tempo') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.way_of_reading') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.fish') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.fish_2') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.fish_3') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.fish_4') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.copying_figures') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.copying_figures_2') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.copying_figures_3') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.interview') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.conclusion') }}
                        </th>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.behavior') }}
                        </th>
                        <th>
                            &nbsp;
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($psihologAnketa as $key => $psihologAnketum)
                        <tr data-entry-id="{{ $psihologAnketum->id }}">
                            <td>

                            </td>
                            <td>
                                {{ $psihologAnketum->id ?? '' }}
                            </td>
                            <td>
                                {{ $psihologAnketum->name_childe->first_name ?? '' }}
                            </td>
                            <td>
                                {{ $psihologAnketum->name_childe->date ?? '' }}
                            </td>
                            <td>
                                {{ $psihologAnketum->name_childe->name_parent ?? '' }}
                            </td>
                            <td>
                                {{ $psihologAnketum->date ?? '' }}
                            </td>
                            <td>
                                {{ $psihologAnketum->name_psyholog->name ?? '' }}
                            </td>
                            <td>
                                {{ App\Models\PsihologAnketum::NEBYLICI_RADIO[$psihologAnketum->nebylici] ?? '' }}
                            </td>
                            <td>
                                {{ $psihologAnketum->visual_memory ?? '' }}
                            </td>
                            <td>
                                {{ App\Models\PsihologAnketum::READING_RADIO[$psihologAnketum->reading] ?? '' }}
                            </td>
                            <td>
                                {{ $psihologAnketum->auditory_memory ?? '' }}
                            </td>
                            <td>
                                {{ App\Models\PsihologAnketum::FOURTH_IS_REDUNDANT_RADIO[$psihologAnketum->fourth_is_redundant] ?? '' }}
                            </td>
                            <td>
                                {{ App\Models\PsihologAnketum::LOGICAL_LINES_RADIO[$psihologAnketum->logical_lines] ?? '' }}
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->social_readiness ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->social_readiness_2 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness_2 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->social_readiness_3 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness_3 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->social_readiness_4 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness_4 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->social_readiness_5 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness_5 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->social_readiness_6 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness_6 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->social_readiness_7 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness_7 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->self_regulation ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->self_regulation_2 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_2 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->self_regulation_3 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_3 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->self_regulation_4 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_4 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->self_regulation_5 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_5 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->self_regulation_6 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_6 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->self_regulation_7 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_7 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->self_regulation_8 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_8 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->self_regulation_9 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_9 ? 'checked' : '' }}>
                            </td>
                            <td>
                                {{ App\Models\PsihologAnketum::MOTIVATION_TO_STUDY_RADIO[$psihologAnketum->motivation_to_study] ?? '' }}
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->speech_physiology ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->speech_physiology_2 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_2 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->speech_physiology_3 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_3 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->speech_physiology_4 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_4 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->speech_physiology_5 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_5 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->speech_physiology_6 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_6 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->speech_physiology_7 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_7 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->speech_physiology_8 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_8 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->physiology_0 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->physiology_0 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->physiology ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->physiology ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->physiology_2 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->physiology_2 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->physiology_3 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->physiology_3 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->physiology_4 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->physiology_4 ? 'checked' : '' }}>
                            </td>
                            <td>
                                {{ App\Models\PsihologAnketum::READING_TEMPO_RADIO[$psihologAnketum->reading_tempo] ?? '' }}
                            </td>
                            <td>
                                {{ App\Models\PsihologAnketum::WAY_OF_READING_RADIO[$psihologAnketum->way_of_reading] ?? '' }}
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->fish ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->fish ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->fish_2 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->fish_2 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->fish_3 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->fish_3 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->fish_4 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->fish_4 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->copying_figures ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->copying_figures ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->copying_figures_2 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->copying_figures_2 ? 'checked' : '' }}>
                            </td>
                            <td>
                                <span style="display:none">{{ $psihologAnketum->copying_figures_3 ?? '' }}</span>
                                <input type="checkbox" disabled="disabled" {{ $psihologAnketum->copying_figures_3 ? 'checked' : '' }}>
                            </td>
                            <td>
                                {{ $psihologAnketum->interview ?? '' }}
                            </td>
                            <td>
                                {{ App\Models\PsihologAnketum::CONCLUSION_SELECT[$psihologAnketum->conclusion] ?? '' }}
                            </td>
                            <td>
                                {{ $psihologAnketum->behavior ?? '' }}
                            </td>
                            <td>
                                @can('psiholog_anketum_show')
                                    <a class="btn btn-xs btn-primary" href="{{ route('admin.psiholog-anketa.show', $psihologAnketum->id) }}">
                                        {{ trans('global.view') }}
                                    </a>
                                @endcan

                                @can('psiholog_anketum_edit')
                                    <a class="btn btn-xs btn-info" href="{{ route('admin.psiholog-anketa.edit', $psihologAnketum->id) }}">
                                        {{ trans('global.edit') }}
                                    </a>
                                @endcan

                                @can('psiholog_anketum_delete')
                                    <form action="{{ route('admin.psiholog-anketa.destroy', $psihologAnketum->id) }}" method="POST" onsubmit="return confirm('{{ trans('global.areYouSure') }}');" style="display: inline-block;">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        <input type="submit" class="btn btn-xs btn-danger" value="{{ trans('global.delete') }}">
                                    </form>
                                @endcan

                            </td>

                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>



@endsection
@section('scripts')
@parent
<script>
    $(function () {
  let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
@can('psiholog_anketum_delete')
  let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
  let deleteButton = {
    text: deleteButtonTrans,
    url: "{{ route('admin.psiholog-anketa.massDestroy') }}",
    className: 'btn-danger',
    action: function (e, dt, node, config) {
      var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
          return $(entry).data('entry-id')
      });

      if (ids.length === 0) {
        alert('{{ trans('global.datatables.zero_selected') }}')

        return
      }

      if (confirm('{{ trans('global.areYouSure') }}')) {
        $.ajax({
          headers: {'x-csrf-token': _token},
          method: 'POST',
          url: config.url,
          data: { ids: ids, _method: 'DELETE' }})
          .done(function () { location.reload() })
      }
    }
  }
  dtButtons.push(deleteButton)
@endcan

  $.extend(true, $.fn.dataTable.defaults, {
    orderCellsTop: true,
    order: [[ 1, 'desc' ]],
    pageLength: 100,
  });
  let table = $('.datatable-PsihologAnketum:not(.ajaxTable)').DataTable({ buttons: dtButtons })
  $('a[data-toggle="tab"]').on('shown.bs.tab click', function(e){
      $($.fn.dataTable.tables(true)).DataTable()
          .columns.adjust();
  });
  
})

</script>
@endsection