<?php

namespace App\Models;

use DateTimeInterface;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SchReport extends Model
{
    use SoftDeletes, HasFactory;

    public $table = 'sch_reports';

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'schclass_id',
        'schstudent_id',
        'schteacher_id',
        'schsubject_id',
        'teacher_id',
        'report',
        'report_en',
        'class_id',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

        public function schclass()
    {
        return $this->belongsTo(SchClass::class, 'schclass_id');
    }

    public function schstudent()
    {
        return $this->belongsTo(Schstudent::class, 'schstudent_id');
    }

    public function schteacher()
    {
        return $this->belongsTo(SchTeacher::class, 'schteacher_id');
    }

    public function schsubject()
    {
        return $this->belongsTo(SchSubject::class, 'schsubject_id');
    }
}
