<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SchClassSchStudent extends Model
{
    use HasFactory;

    public $table = 'sch_class_schstudent';

    protected $fillable = [
        'sch_class_id',
        'schstudent_id',
    ];

    public function schClass()
    {
        return $this->belongsTo(SchClass::class, 'sch_class_id');
    }

    public function schstudent()
    {
        return $this->belongsTo(Schstudent::class, 'schstudent_id');
    }
    protected static function booted()
    {
        static::created(function ($schClassSchStudent) {
            $schstudent = Schstudent::find($schClassSchStudent->schstudent_id);
            if ($schstudent) {
                $schstudent->update(['schclass_id' => $schClassSchStudent->sch_class_id]);
                \Log::info('schclass_id updated for student ID: ' . $schClassSchStudent->schstudent_id);
            } else {
                \Log::error('Student not found for ID: ' . $schClassSchStudent->schstudent_id);
            }
        });
    }
}
