<?php

namespace App\Http\Requests;

use App\Models\SchReport;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Symfony\Component\HttpFoundation\Response;

class MassDestroySchReportRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(Gate::denies('sch_report_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:sch_reports,id',
        ];
    }
}
