<?php

namespace App\Http\Requests;

use App\Models\SchClass;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Symfony\Component\HttpFoundation\Response;

class MassDestroySchClassRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(Gate::denies('sch_class_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:sch_classes,id',
        ];
    }
}
