<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\CsvImportTrait;
use App\Http\Requests\MassDestroySchSubjectRequest;
use App\Http\Requests\StoreSchSubjectRequest;
use App\Http\Requests\UpdateSchSubjectRequest;
use App\Models\SchClass;
use App\Models\SchSubject;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SchSubjectController extends Controller
{
    use CsvImportTrait;

    public function index()
    {
        abort_if(Gate::denies('sch_subject_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $schSubjects = SchSubject::with(['sch_class'])->get();

        $sch_classes = SchClass::get();

        return view('admin.schSubjects.index', compact('schSubjects', 'sch_classes'));
    }

    public function create()
    {
        abort_if(Gate::denies('sch_subject_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $sch_classes = SchClass::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        return view('admin.schSubjects.create', compact('sch_classes'));
    }

    public function store(StoreSchSubjectRequest $request)
    {
        $schSubject = SchSubject::create($request->all());

        return redirect()->route('admin.sch-subjects.index');
    }

    public function edit(SchSubject $schSubject)
    {
        abort_if(Gate::denies('sch_subject_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $sch_classes = SchClass::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $schSubject->load('sch_class');

        return view('admin.schSubjects.edit', compact('schSubject', 'sch_classes'));
    }

    public function update(UpdateSchSubjectRequest $request, SchSubject $schSubject)
    {
        $schSubject->update($request->all());

        return redirect()->route('admin.sch-subjects.index');
    }

    public function show(SchSubject $schSubject)
    {
        abort_if(Gate::denies('sch_subject_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $schSubject->load('sch_class', 'schsubjectSchReports', 'schsubjectSchTeachers');

        return view('admin.schSubjects.show', compact('schSubject'));
    }

    public function destroy(SchSubject $schSubject)
    {
        abort_if(Gate::denies('sch_subject_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $schSubject->delete();

        return back();
    }

    public function massDestroy(MassDestroySchSubjectRequest $request)
    {
        $schSubjects = SchSubject::find(request('ids'));

        foreach ($schSubjects as $schSubject) {
            $schSubject->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
